/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.hud.impl;

import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.msdf.Font;
import Krasnodar.rockstarnew.framework.msdf.Fonts;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.ui.hud.HudList;
import Krasnodar.rockstarnew.utility.animation.base.Animation;
import Krasnodar.rockstarnew.utility.animation.base.Easing;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_408;
import net.minecraft.class_5250;
import net.minecraft.class_640;

public class StaffList
extends HudList {
    private final Animation animationWidth = new Animation(200L, 100.0f, Easing.QUAD_IN_OUT);
    private final Animation animationScale = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);
    private final Animation animationVisible = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);
    private final Map<String, StaffModule> modules = new LinkedHashMap<String, StaffModule>();
    private final Set<String> staffPrefix = Set.of("helper", "\u1d00\u0434\u043c\u0438\u043d", "moder", "staff", "admin", "curator", "\u0441\u0442\u0430\u0436\u0451\u0440", "\u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a", "\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a", "\u0430\u0434\u043c\u0438\u043d", "\u043c\u043e\u0434\u0435\u0440", "\u043c\u043e\u0434\u0435\u0440\u0430\u0442\u043e\u0440", "\u0445\u0435\u043b\u043f\u0435\u0440", "\u043a\u0443\u0440\u0430\u0442\u043e\u0440", "owner", "\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446", "\u0433\u043b.\u0430\u0434\u043c\u0438\u043d");
    private final Map<String, class_2960> skinTextureCache = new HashMap<String, class_2960>();
    private long lastStaffUpdate = 0L;
    private long lastSkinCacheClear = 0L;
    private final Set<String> currentStaffKeys = new HashSet<String>();
    private final BooleanSetting alwaysDisplay = new BooleanSetting(this, "hud.always_display");
    private final BooleanSetting showTime = new BooleanSetting(this, "hud.stafflist.show_time");

    public StaffList() {
        super("hud.stafflist", "icons/hud/staff.png");
    }

    @Override
    public void update(UIContext context) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastStaffUpdate > 1000L && mc.method_1562() != null) {
            this.updateStaffList();
            this.lastStaffUpdate = currentTime;
        }
        if (currentTime - this.lastSkinCacheClear > 30000L) {
            this.skinTextureCache.clear();
            this.lastSkinCacheClear = currentTime;
        }
        this.modules.entrySet().removeIf(entry -> ((StaffModule)entry.getValue()).isDelete());
        boolean hidden = this.modules.size() == 1 && this.modules.values().iterator().next().animation.getTargetValue() == 0.0f;
        this.animationScale.update(hidden ? 0.0f : 1.0f);
        float height = (float)(18.0 + this.modules.values().stream().mapToDouble(StaffModule::getHeight).sum());
        float width = (float)this.modules.values().stream().mapToDouble(StaffModule::updateWidth).max().orElse(92.0);
        this.width = width = this.animationWidth.update(width);
        this.height = height;
        if (this.height > 18.0f) {
            this.height += 5.0f;
        }
        super.update(context);
    }

    @Override
    protected void renderComponent(UIContext context) {
        super.renderComponent(context);
        this.animationVisible.update(StaffList.mc.field_1755 instanceof class_408 || !this.modules.isEmpty() ? 1.0f : 0.0f);
        if (this.animationVisible.getValue() > 0.0f && this.height > 23.0f) {
            float offsetY = this.y + 22.0f;
            int index = 0;
            for (Map.Entry<String, StaffModule> entry : this.modules.entrySet()) {
                StaffModule module = entry.getValue();
                if (!(module.animation.getValue() > 0.0f)) continue;
                if (offsetY != this.y + 22.0f) {
                    float off = -4.5f + 4.5f * module.animation.getValue();
                    context.drawRect(this.x, offsetY + off, this.width, 0.5f, Colors.getSeparatorColor());
                }
                module.render(context, this.x, offsetY, this.width, index, this.currentStaffKeys.contains(entry.getKey()));
                offsetY += module.getHeight();
                ++index;
            }
        }
    }

    private void updateStaffList() {
        if (mc.method_1562() == null) {
            return;
        }
        this.currentStaffKeys.clear();
        if (StaffList.mc.field_1755 instanceof class_408) {
            String testKey = "\u0410\u0434\u043c\u0438\u043d \u0411\u0430\u0431\u0430\u0439\u043a\u0430";
            class_5250 testDisplayName = class_2561.method_43470((String)testKey);
            this.modules.computeIfAbsent(testKey, arg_0 -> this.lambda$updateStaffList$1((class_2561)testDisplayName, testKey, arg_0));
            this.currentStaffKeys.add(testKey);
            return;
        }
        for (class_640 entry : mc.method_1562().method_2880()) {
            String name;
            String display;
            String prefix;
            GameProfile profile = entry.method_2966();
            class_2561 displayName = entry.method_2971();
            if (displayName == null || profile == null || (prefix = (display = displayName.getString()).replace(name = profile.getName(), "").trim()).length() < 2 || !this.containsAnyKeyword(prefix)) continue;
            String key = display;
            Status status = entry.method_2958() == class_1934.field_9219 ? Status.VANISHED : Status.NONE;
            class_5250 finalDisplayName = class_2561.method_43470((String)display);
            this.modules.computeIfAbsent(key, arg_0 -> this.lambda$updateStaffList$2((class_2561)finalDisplayName, key, name, status, arg_0));
            this.currentStaffKeys.add(key);
        }
    }

    public boolean containsAnyKeyword(String text) {
        String lower = text.toLowerCase(Locale.US);
        for (String keyword : this.staffPrefix) {
            if (!lower.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean show() {
        return !this.modules.isEmpty() || StaffList.mc.field_1755 instanceof class_408;
    }

    private String formatTime(long ms) {
        long minutes = ms / 60000L;
        long seconds = ms % 60000L / 1000L;
        return String.format("%d:%02d", minutes, seconds);
    }

    private /* synthetic */ StaffModule lambda$updateStaffList$2(class_2561 finalDisplayName, String key, String name, Status status, String k) {
        return new StaffModule(finalDisplayName, key, name, status);
    }

    private /* synthetic */ StaffModule lambda$updateStaffList$1(class_2561 testDisplayName, String testKey, String k) {
        return new StaffModule(testDisplayName, testKey, "\u0411\u0430\u0431\u0430\u0439\u043a\u0430", Status.NONE);
    }

    private class StaffModule {
        private final Animation animation = new Animation(150L, 0.01f, Easing.QUAD_IN_OUT);
        private final Animation animationColor = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);
        private final Animation hoverAnimation = new Animation(200L, 0.0f, Easing.QUAD_IN_OUT);
        private final class_2561 displayNameText;
        private final String key;
        private final String name;
        private final Status status;
        private final long appearTime;

        public StaffModule(class_2561 displayNameText, String key, String name, Status status) {
            this.displayNameText = displayNameText;
            this.key = key;
            this.name = name;
            this.status = status;
            this.appearTime = System.currentTimeMillis();
        }

        public float updateWidth() {
            float width = 60.0f;
            Font font = Fonts.REGULAR.getFont(7.0f);
            String prefix = this.displayNameText.getString().replace(this.name, "").trim();
            float prefixWidth = font.width(prefix);
            float nameWidth = font.width(this.name);
            float leftTextWidth = 6.0f + prefixWidth + 3.0f + nameWidth + 3.0f;
            if (StaffList.this.showTime.isEnabled()) {
                String time = StaffList.this.formatTime(System.currentTimeMillis() - this.appearTime);
                float rightTextWidth = font.width(time) + 6.0f;
                if (width - (leftTextWidth + rightTextWidth) < 6.0f) {
                    width += leftTextWidth + rightTextWidth + 6.0f - width;
                }
            } else {
                float rightCircleWidth = 12.0f;
                if (width - (leftTextWidth + rightCircleWidth) < 6.0f) {
                    width += leftTextWidth + rightCircleWidth + 6.0f - width;
                }
            }
            return width;
        }

        public float getHeight() {
            return 18.0f * this.animation.getValue();
        }

        public void render(UIContext ctx, float x, float y, float width, int i, boolean present) {
            Font font = Fonts.REGULAR.getFont(7.0f);
            this.animation.update(present ? 1.0f : 0.0f);
            if (this.animation.getValue() == 0.0f) {
                return;
            }
            float off = -4.5f + 4.5f * this.animation.getValue();
            String fullText = this.displayNameText.getString();
            String prefix = fullText.replace(this.name, "").trim();
            float currentX = x + 6.0f * this.animation.getValue();
            float textY = y + off + GuiUtility.getMiddleOfBox(font.height(), 18.0f);
            ColorRGBA prefixColor = this.getPrefixColor(prefix);
            ctx.drawText(font, prefix, currentX, textY, prefixColor.withAlpha(255.0f * this.animation.getValue()));
            ctx.drawText(font, this.name, currentX += font.width(prefix) + 3.0f, textY, Colors.getTextColor().withAlpha(255.0f * this.animation.getValue()));
            float circleX = x + width - 6.0f * this.animation.getValue() - 4.0f;
            float circleY = y + off + 9.0f;
            float circleRadius = 3.0f;
            boolean isHovered = false;
            if (IMinecraft.mc.field_1755 instanceof class_408) {
                double mouseX = IMinecraft.mc.field_1729.method_1603() * (double)IMinecraft.mc.method_22683().method_4486() / (double)IMinecraft.mc.method_22683().method_4480();
                double mouseY = IMinecraft.mc.field_1729.method_1604() * (double)IMinecraft.mc.method_22683().method_4502() / (double)IMinecraft.mc.method_22683().method_4507();
                double distance = Math.sqrt(Math.pow(mouseX - (double)circleX, 2.0) + Math.pow(mouseY - (double)circleY, 2.0));
                isHovered = distance <= (double)(circleRadius + 2.0f);
            }
            this.hoverAnimation.update(isHovered ? 1.0f : 0.0f);
            if (StaffList.this.showTime.isEnabled()) {
                String timeText = StaffList.this.formatTime(System.currentTimeMillis() - this.appearTime);
                ctx.drawRightText(font, timeText, x + width - 6.0f * this.animation.getValue(), textY, Colors.getTextColor().withAlpha(255.0f * this.animation.getValue()));
            } else {
                float circleAlpha = (1.0f - this.hoverAnimation.getValue()) * this.animation.getValue();
                if (circleAlpha > 0.0f) {
                    ctx.drawRoundedRect(circleX - circleRadius, circleY - circleRadius, circleRadius * 2.0f, circleRadius * 2.0f, BorderRadius.all(circleRadius), ColorRGBA.GREEN.withAlpha(255.0f * circleAlpha));
                }
                if (this.hoverAnimation.getValue() > 0.0f) {
                    String timeText = StaffList.this.formatTime(System.currentTimeMillis() - this.appearTime);
                    ctx.drawRightText(font, timeText, x + width - 6.0f * this.animation.getValue(), textY, Colors.getTextColor().withAlpha(255.0f * this.animation.getValue() * this.hoverAnimation.getValue()));
                }
            }
        }

        private ColorRGBA getPrefixColor(String prefix) {
            String lower = prefix.toLowerCase(Locale.US);
            if (lower.contains("owner") || lower.contains("\u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446")) {
                return ColorRGBA.RED;
            }
            if (lower.contains("admin") || lower.contains("\u0430\u0434\u043c\u0438\u043d") || lower.contains("\u1d00\u0434\u043c\u0438\u043d")) {
                return new ColorRGBA(255.0f, 85.0f, 85.0f, 255.0f);
            }
            if (lower.contains("moder") || lower.contains("\u043c\u043e\u0434\u0435\u0440")) {
                return new ColorRGBA(85.0f, 255.0f, 85.0f, 255.0f);
            }
            if (lower.contains("helper") || lower.contains("\u0445\u0435\u043b\u043f\u0435\u0440") || lower.contains("\u043f\u043e\u043c\u043e\u0449\u043d\u0438\u043a")) {
                return new ColorRGBA(85.0f, 170.0f, 255.0f, 255.0f);
            }
            if (lower.contains("curator") || lower.contains("\u043a\u0443\u0440\u0430\u0442\u043e\u0440")) {
                return new ColorRGBA(255.0f, 170.0f, 0.0f, 255.0f);
            }
            if (lower.contains("\u0441\u0442\u0430\u0436\u0451\u0440") || lower.contains("\u0441\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a")) {
                return new ColorRGBA(170.0f, 170.0f, 170.0f, 255.0f);
            }
            return Colors.getTextColor();
        }

        public boolean isDelete() {
            return this.animation.getValue() == 0.0f;
        }
    }

    public static enum Status {
        NONE,
        VANISHED;

    }

    public static class Staff {
        private class_2561 prefix;
        private String name;
        private boolean isSpec;
        private Status status;

        public class_2561 getPrefix() {
            return this.prefix;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSpec() {
            return this.isSpec;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setPrefix(class_2561 prefix) {
            this.prefix = prefix;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSpec(boolean isSpec) {
            this.isSpec = isSpec;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Staff)) {
                return false;
            }
            Staff other = (Staff)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSpec() != other.isSpec()) {
                return false;
            }
            class_2561 this$prefix = this.getPrefix();
            class_2561 other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Staff;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSpec() ? 79 : 97);
            class_2561 $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            return result;
        }

        public String toString() {
            return "StaffList.Staff(prefix=" + String.valueOf(this.getPrefix()) + ", name=" + this.getName() + ", isSpec=" + this.isSpec() + ", status=" + String.valueOf((Object)this.getStatus()) + ")";
        }

        public Staff(class_2561 prefix, String name, boolean isSpec, Status status) {
            this.prefix = prefix;
            this.name = name;
            this.isSpec = isSpec;
            this.status = status;
        }
    }
}

